<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'About Us')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Pages', 'title' => 'About Us')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body position-relative">
                                    <div class="position-absolute top-0 end-0" style="max-width: 350px">
                                        <img alt="auth-card-bg" class="auth-card-bg-img" src="/images/auth-card-bg.svg" />
                                    </div>
                                    <div class="row bg-light bg-opacity-50">
                                        <div class="col-lg-8 mx-auto py-5 text-center">
                                            <!-- Pre Info Text -->
                                            <span class="fw-semibold text-muted fst-italic">Trusted by 1M+ AI innovators worldwide</span>
                                            <!-- Avatar Group -->
                                            <div class="avatar-group avatar-group-sm justify-content-center mt-3">
                                                <div class="avatar">
                                                    <img alt="Dr. Ava Lee – AI Researcher" class="avatar-sm rounded-circle" src="/images/users/user-7.jpg" />
                                                </div>
                                                <div class="avatar">
                                                    <img alt="Ethan King – Data Scientist" class="avatar-sm rounded-circle" src="/images/users/user-8.jpg" />
                                                </div>
                                                <div class="avatar">
                                                    <img alt="Lucas White – ML Engineer" class="avatar-sm rounded-circle" src="/images/users/user-9.jpg" />
                                                </div>
                                                <div class="avatar">
                                                    <img alt="Sophia Chen – Robotics Expert" class="avatar-sm rounded-circle" src="/images/users/user-1.jpg" />
                                                </div>
                                                <div class="avatar">
                                                    <img alt="Raj Patel – AI Strategist" class="avatar-sm rounded-circle" src="/images/users/user-2.jpg" />
                                                </div>
                                            </div>
                                            <!-- Hero Title -->
                                            <h1 class="my-4 fs-36 fw-bold lh-base">
                                                Accelerate Innovation with the
                                                <span class="text-primary">AI Control Panel</span>
                                                –
                                                <span class="fst-italic text-muted">Smart. Scalable. Built for the Future.</span>
                                            </h1>
                                            <!-- Hero Description -->
                                            <p class="mb-4 fs-sm text-muted lh-lg">
                                                Design, deploy, and manage machine learning models faster than ever. Our AI Control Panel empowers teams to collaborate, monitor, and scale securely with intuitive dashboards and cutting-edge analytics.
                                            </p>
                                            <!-- Call to Action Buttons -->
                                            <div class="d-flex gap-1 gap-sm-2 flex-wrap justify-content-center">
                                                <a class="btn btn-light py-2 fw-semibold" href="#!" target="_blank">
                                                    <i class="ti ti-phone-ringing fs-xl me-2"></i>
                                                    Get a Demo
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <section class="py-5">
                                        <div class="container">
                                            <!-- Section Heading -->
                                            <div class="row">
                                                <div class="col-12 text-center">
                                                    <span class="text-muted rounded-3 d-inline-block">💼 Tailored Solutions for Every Need</span>
                                                    <h2 class="mt-3 fw-bold mb-5">
                                                        Explore Our Professional
                                                        <span class="text-primary">Services</span>
                                                        and Expertise
                                                    </h2>
                                                </div>
                                            </div>
                                            <!-- First Row of Service Cards -->
                                            <div class="row text-center">
                                                <!-- Strategic Consulting -->
                                                <div class="col-xl-4 col-md-6">
                                                    <div class="card border-0 shadow-none p-2 card-h-100">
                                                        <div class="card-body pb-0">
                                                            <div class="avatar-xl mx-auto mb-3">
                                                                <span class="avatar-title bg-secondary-subtle text-secondary rounded-circle fs-22">
                                                                    <i class="ti ti-device-desktop"></i>
                                                                </span>
                                                            </div>
                                                            <h4 class="mb-2">Strategic Consulting</h4>
                                                            <p class="text-muted mb-3">We help businesses define clear digital goals and create custom strategies that align with long-term success. From planning to execution.</p>
                                                        </div>
                                                        <div class="card-footer border-0 pt-0">
                                                            <a class="link-primary fw-semibold" href="#">
                                                                Know more
                                                                <i class="ti ti-arrow-right ms-1 align-middle"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- SEO & Traffic Growth -->
                                                <div class="col-xl-4 col-md-6">
                                                    <div class="card border-0 shadow-none p-2 card-h-100">
                                                        <div class="card-body pb-0">
                                                            <div class="avatar-xl mx-auto mb-3">
                                                                <span class="avatar-title bg-secondary-subtle text-secondary rounded-circle fs-22">
                                                                    <i class="ti ti-layout"></i>
                                                                </span>
                                                            </div>
                                                            <h4 class="mb-2">SEO &amp; Traffic Growth</h4>
                                                            <p class="text-muted mb-3">Boost your search visibility and drive organic traffic with our comprehensive SEO services — including keyword strategy, technical audits, etc.</p>
                                                        </div>
                                                        <div class="card-footer border-0 pt-0">
                                                            <a class="link-primary fw-semibold" href="#">
                                                                Know more
                                                                <i class="ti ti-arrow-right ms-1 align-middle"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Social Media Management -->
                                                <div class="col-xl-4 col-md-6">
                                                    <div class="card border-0 shadow-none p-2 card-h-100">
                                                        <div class="card-body pb-0">
                                                            <div class="avatar-xl mx-auto mb-3">
                                                                <span class="avatar-title bg-secondary-subtle text-secondary rounded-circle fs-22">
                                                                    <i class="ti ti-brush"></i>
                                                                </span>
                                                            </div>
                                                            <h4 class="mb-2">Social Media Management</h4>
                                                            <p class="text-muted mb-3">Elevate your brand's presence with targeted content, community engagement, and performance analytics across platforms like Instagram, Facebook, etc.</p>
                                                        </div>
                                                        <div class="card-footer border-0 pt-0">
                                                            <a class="link-primary fw-semibold" href="#">
                                                                Know more
                                                                <i class="ti ti-arrow-right ms-1 align-middle"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Custom Web Development -->
                                                <div class="col-xl-4 col-md-6">
                                                    <div class="card border-0 shadow-none p-2 card-h-100">
                                                        <div class="card-body pb-0">
                                                            <div class="avatar-xl mx-auto mb-3">
                                                                <span class="avatar-title bg-secondary-subtle text-secondary rounded-circle fs-22">
                                                                    <i class="ti ti-code"></i>
                                                                </span>
                                                            </div>
                                                            <h4 class="mb-2">Custom Web Development</h4>
                                                            <p class="text-muted mb-3">We build modern, scalable websites and applications tailored to your business needs — optimized for speed, mobile responsiveness.</p>
                                                        </div>
                                                        <div class="card-footer border-0 pt-0">
                                                            <a class="link-primary fw-semibold" href="#">
                                                                Know more
                                                                <i class="ti ti-arrow-right ms-1 align-middle"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Brand Identity & Design -->
                                                <div class="col-xl-4 col-md-6">
                                                    <div class="card border-0 shadow-none p-2 card-h-100">
                                                        <div class="card-body pb-0">
                                                            <div class="avatar-xl mx-auto mb-3">
                                                                <span class="avatar-title bg-secondary-subtle text-secondary rounded-circle fs-22">
                                                                    <i class="ti ti-rocket"></i>
                                                                </span>
                                                            </div>
                                                            <h4 class="mb-2">Brand Identity &amp; Design</h4>
                                                            <p class="text-muted mb-3">From logos to full brand systems, we create memorable visual identities that express your values and connect with your target audience.</p>
                                                        </div>
                                                        <div class="card-footer border-0 pt-0">
                                                            <a class="link-primary fw-semibold" href="#">
                                                                Know more
                                                                <i class="ti ti-arrow-right ms-1 align-middle"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Analytics & Insights -->
                                                <div class="col-xl-4 col-md-6">
                                                    <div class="card border-0 shadow-none p-2 card-h-100">
                                                        <div class="card-body pb-0">
                                                            <div class="avatar-xl mx-auto mb-3">
                                                                <span class="avatar-title bg-secondary-subtle text-secondary rounded-circle fs-22">
                                                                    <i class="ti ti-palette"></i>
                                                                </span>
                                                            </div>
                                                            <h4 class="mb-2">Analytics &amp; Insights</h4>
                                                            <p class="text-muted mb-3">Turn data into decisions with real-time dashboards, performance reports, and analytics solutions that help you measure success.</p>
                                                        </div>
                                                        <div class="card-footer border-0 pt-0">
                                                            <a class="link-primary fw-semibold" href="#">
                                                                Know more
                                                                <i class="ti ti-arrow-right ms-1 align-middle"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </section>
                                    <section class="border-top border-dashed py-5">
                                        <div class="container">
                                            <div class="row">
                                                <div class="col-12 text-center">
                                                    <h3 class="fw-bold mb-5">
                                                        Meet Our
                                                        <mark class="text-warning">Dedicated</mark>
                                                        Team
                                                    </h3>
                                                </div>
                                            </div>
                                            <div class="row row-cols-xxl-5 row-cols-md-3 row-cols-1 justify-content-center">
                                                <div class="col">
                                                    <div class="card border-light">
                                                        <div class="card-body border-0 pb-0 text-center">
                                                            <div class="mx-auto mb-3">
                                                                <img alt="Emily Carter" class="img-fluid rounded" src="/images/users/user-1.jpg" />
                                                            </div>
                                                            <h4 class="mb-1 fs-md">David Dev</h4>
                                                            <p class="text-muted mb-3 fst-italic fs-sm">Chief Executive Officer</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="card border-light">
                                                        <div class="card-body border-0 pb-0 text-center">
                                                            <div class="mx-auto mb-3">
                                                                <img alt="Michael Lee" class="img-fluid rounded" src="/images/users/user-2.jpg" />
                                                            </div>
                                                            <h4 class="mb-1 fs-md">Michael Lee</h4>
                                                            <p class="text-muted mb-3 fst-italic fs-sm">Head of Development</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="card border-light">
                                                        <div class="card-body border-0 pb-0 text-center">
                                                            <div class="mx-auto mb-3">
                                                                <img alt="Sophia Gomez" class="img-fluid rounded" src="/images/users/user-3.jpg" />
                                                            </div>
                                                            <h4 class="mb-1 fs-md">Sophia Gomez</h4>
                                                            <p class="text-muted mb-3 fst-italic fs-sm">Marketing Director</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="card border-light">
                                                        <div class="card-body border-0 pb-0 text-center">
                                                            <div class="mx-auto mb-3">
                                                                <img alt="Daniel Kim" class="img-fluid rounded" src="/images/users/user-4.jpg" />
                                                            </div>
                                                            <h4 class="mb-1 fs-md">Daniel Kim</h4>
                                                            <p class="text-muted mb-3 fst-italic fs-sm">UI/UX Lead</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="card border-light">
                                                        <div class="card-body border-0 pb-0 text-center">
                                                            <div class="mx-auto mb-3">
                                                                <img alt="Hannah White" class="img-fluid rounded" src="/images/users/user-8.jpg" />
                                                            </div>
                                                            <h4 class="mb-1 fs-md">Hannah White</h4>
                                                            <p class="text-muted mb-3 fst-italic fs-sm">Product Manager</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="card border-light">
                                                        <div class="card-body border-0 pb-0 text-center">
                                                            <div class="mx-auto mb-3">
                                                                <img alt="Liam Smith" class="img-fluid rounded" src="/images/users/user-5.jpg" />
                                                            </div>
                                                            <h4 class="mb-1 fs-md">Liam Smith</h4>
                                                            <p class="text-muted mb-3 fst-italic fs-sm">Frontend Developer</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="card border-light">
                                                        <div class="card-body border-0 pb-0 text-center">
                                                            <div class="mx-auto mb-3">
                                                                <img alt="Chloe Brown" class="img-fluid rounded" src="/images/users/user-6.jpg" />
                                                            </div>
                                                            <h4 class="mb-1 fs-md">Chloe Brown</h4>
                                                            <p class="text-muted mb-3 fst-italic fs-sm">Data Analyst</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="card border-light">
                                                        <div class="card-body border-0 pb-0 text-center">
                                                            <div class="mx-auto mb-3">
                                                                <img alt="Ethan Ross" class="img-fluid rounded" src="/images/users/user-7.jpg" />
                                                            </div>
                                                            <h4 class="mb-1 fs-md">Ethan Ross</h4>
                                                            <p class="text-muted mb-3 fst-italic fs-sm">QA Specialist</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="card border-light">
                                                        <div class="card-body border-0 pb-0 text-center">
                                                            <div class="mx-auto mb-3">
                                                                <img alt="Lena Marshall" class="img-fluid rounded" src="/images/users/user-9.jpg" />
                                                            </div>
                                                            <h4 class="mb-1 fs-md">Lena Marshall</h4>
                                                            <p class="text-muted mb-3 fst-italic fs-sm">UI/UX Designer</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </section>
                                    <section class="border border-dashed p-5 pb-3 rounded bg-light bg-opacity-25">
                                        <div class="container">
                                            <div class="row">
                                                <div class="col-12 text-center">
                                                    <h3 class="fw-bold mb-5">
                                                        Expanding Horizons.
                                                        <span class="text-primary">Empowering</span>
                                                        Futures
                                                    </h3>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-xl-4">
                                                    <div class="card border-light p-2 card-h-100">
                                                        <div class="card-body pb-0">
                                                            <img class="avatar-xl mb-3 rounded-circle" src="/images/flags/us.svg" />
                                                            <h4 class="fw-semibold mb-2">United States</h4>
                                                            <p class="text-muted mb-3">
                                                                501 Elm Street, Suite 500
                                                                <br />
                                                                New York, NY 10001
                                                                <br />
                                                                USA
                                                            </p>
                                                        </div>
                                                        <div class="card-footer border-0 pt-0">
                                                            <a class="link-primary fw-semibold" href="#">
                                                                Contact Us
                                                                <i class="ti ti-arrow-right ms-1 align-middle"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- UK Office -->
                                                <div class="col-xl-4">
                                                    <div class="card border-light p-2 card-h-100">
                                                        <div class="card-body pb-0">
                                                            <img class="avatar-xl mb-3 rounded-circle" src="/images/flags/gb.svg" />
                                                            <h4 class="fw-semibold mb-2">United Kingdom</h4>
                                                            <p class="text-muted mb-3">
                                                                221B Baker Street
                                                                <br />
                                                                London, NW1 6XE
                                                                <br />
                                                                United Kingdom
                                                            </p>
                                                        </div>
                                                        <div class="card-footer border-0 pt-0">
                                                            <a class="link-primary fw-semibold" href="#">
                                                                Contact Us
                                                                <i class="ti ti-arrow-right ms-1 align-middle"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- India Office -->
                                                <div class="col-xl-4">
                                                    <div class="card border-light p-2 card-h-100">
                                                        <div class="card-body pb-0">
                                                            <img class="avatar-xl mb-3 rounded-circle" src="/images/flags/in.svg" />
                                                            <h4 class="fw-semibold mb-2">India</h4>
                                                            <p class="text-muted mb-3">
                                                                15 MG Road, 2nd Floor
                                                                <br />
                                                                Bengaluru, Karnataka 560001
                                                                <br />
                                                                India
                                                            </p>
                                                        </div>
                                                        <div class="card-footer border-0 pt-0">
                                                            <a class="link-primary fw-semibold" href="#">
                                                                Contact Us
                                                                <i class="ti ti-arrow-right ms-1 align-middle"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end row -->
                                        </div>
                                    </section>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
