<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Sitemap')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Pages', 'title' => 'Sitemap')) ?>

                    <div class="row">
                        <!-- Column 1: AI Dashboards -->
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="fw-bold text-uppercase">AI Dashboards</h5>
                                    <ul class="list-unstyled sitemap-list mt-3">
                                        <li>
                                            <a class="link-reset fw-semibold" href="#">Analytics</a>
                                            <ul>
                                                <li>
                                                    <a class="link-reset" href="#">Model Metrics</a>
                                                </li>
                                                <li>
                                                    <a class="link-reset" href="#">User Insights</a>
                                                </li>
                                                <li>
                                                    <a class="link-reset" href="#">Prediction Logs</a>
                                                </li>
                                                <li>
                                                    <a class="link-reset" href="#">Real-Time Monitor</a>
                                                </li>
                                                <li>
                                                    <a class="link-reset" href="#">Data Pipelines</a>
                                                </li>
                                            </ul>
                                        </li>
                                        <li>
                                            <a class="link-reset fw-semibold" href="#">Model Hub</a>
                                            <ul>
                                                <li><a class="link-reset" href="#">Overview</a></li>
                                                <li>
                                                    <a class="link-reset" href="#">Upload Model</a>
                                                </li>
                                                <li>
                                                    <a class="link-reset" href="#">Version Control</a>
                                                </li>
                                            </ul>
                                        </li>
                                        <li>
                                            <a class="link-reset fw-semibold" href="#">AI Documentation</a>
                                        </li>
                                        <li>
                                            <a class="link-reset fw-semibold" href="#">Sign In</a>
                                        </li>
                                        <li>
                                            <a class="link-reset fw-semibold" href="#">Create Account</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- Column 2: AI Applications -->
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="fw-bold text-uppercase">AI Applications</h5>
                                    <ul class="list-unstyled sitemap-list mt-3">
                                        <li>
                                            <a class="link-reset fw-semibold" href="#">
                                                <i class="ti ti-calendar me-1 text-muted"></i>
                                                Training Scheduler
                                            </a>
                                        </li>
                                        <li>
                                            <a class="link-reset fw-semibold" href="#">
                                                <i class="ti ti-mail me-1 text-muted"></i>
                                                Notifications
                                            </a>
                                            <ul>
                                                <li><a class="link-reset" href="#">Inbox</a></li>
                                                <li><a class="link-reset" href="#">Alerts</a></li>
                                                <li>
                                                    <a class="link-reset" href="#">Send Message</a>
                                                </li>
                                            </ul>
                                        </li>
                                        <li>
                                            <a class="link-reset fw-semibold" href="#">
                                                <i class="ti ti-users me-1 text-muted"></i>
                                                Teams
                                            </a>
                                            <ul>
                                                <li><a class="link-reset" href="#">Members</a></li>
                                                <li><a class="link-reset" href="#">Invite</a></li>
                                                <li>
                                                    <a class="link-reset" href="#">Permissions</a>
                                                </li>
                                            </ul>
                                        </li>
                                        <li>
                                            <a class="link-reset fw-semibold" href="#">
                                                <i class="ti ti-briefcase me-1 text-muted"></i>
                                                AI Projects
                                            </a>
                                            <ul>
                                                <li><a class="link-reset" href="#">Overview</a></li>
                                                <li>
                                                    <a class="link-reset" href="#">New Project</a>
                                                </li>
                                                <li><a class="link-reset" href="#">Tasks</a></li>
                                            </ul>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- Column 3: AI Reports & Settings -->
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="fw-bold text-uppercase">AI Reports &amp; Settings</h5>
                                    <ul class="list-unstyled sitemap-list mt-3">
                                        <li>
                                            <a class="link-primary fw-semibold" href="#">
                                                <i class="ti ti-chart-bar me-1"></i>
                                                Reports
                                            </a>
                                            <ul>
                                                <li>
                                                    <a class="link-reset" href="#">Model Accuracy</a>
                                                </li>
                                                <li>
                                                    <a class="link-reset" href="#">User Activity</a>
                                                </li>
                                                <li>
                                                    <a class="link-reset" href="#">Performance Trends</a>
                                                </li>
                                            </ul>
                                        </li>
                                        <li>
                                            <a class="link-info fw-semibold" href="#">
                                                <i class="ti ti-wallet me-1"></i>
                                                Billing
                                            </a>
                                            <ul>
                                                <li>
                                                    <a class="link-reset" href="#">Subscriptions</a>
                                                </li>
                                                <li><a class="link-reset" href="#">Payments</a></li>
                                                <li><a class="link-reset" href="#">Credits</a></li>
                                            </ul>
                                        </li>
                                        <li>
                                            <a class="link-danger fw-semibold" href="#">
                                                <i class="ti ti-settings me-1"></i>
                                                Settings
                                            </a>
                                            <ul>
                                                <li><a class="link-reset" href="#">General</a></li>
                                                <li>
                                                    <a class="link-reset" href="#">Appearance</a>
                                                </li>
                                                <li>
                                                    <a class="link-reset" href="#">Integrations</a>
                                                </li>
                                                <li>
                                                    <a class="link-reset" href="#">Audit Logs</a>
                                                </li>
                                            </ul>
                                        </li>
                                        <li>
                                            <a class="link-reset fw-semibold" href="#">
                                                <i class="ti ti-logout me-1"></i>
                                                Logout
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
