<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Chart Widgets')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Widgets', 'title' => 'Charts')) ?>

                    <div class="row">
                        <!-- Leads Generated -->
                        <div class="col-md-6 col-xxl-3">
                            <div class="card card-h-100">
                                <div class="card-body">
                                    <div class="row align-items-center">
                                        <div class="col-6">
                                            <h5 class="text-muted fs-sm text-uppercase text-truncate" title="Leads Generated">Leads Generated</h5>
                                            <div class="d-flex align-items-center gap-2 my-3">
                                                <div class="avatar-md flex-shrink-0">
                                                    <span class="avatar-title text-bg-light rounded-circle fs-22">
                                                        <i class="ti ti-users"></i>
                                                    </span>
                                                </div>
                                                <!-- avatar-md -->
                                                <h3 class="mb-0 fw-bold">
                                                    <span data-target="48.2">0</span>
                                                    k
                                                </h3>
                                            </div>
                                            <!-- stat-container -->
                                            <p class="mb-0 text-muted">
                                                <span class="text-success me-2">
                                                    5.12%
                                                    <i class="ti ti-trending-up ms-1"></i>
                                                </span>
                                                <span class="text-nowrap">2.3k Up</span>
                                            </p>
                                        </div>
                                        <!-- col-6 -->
                                        <div class="col-6">
                                            <div class="text-end">
                                                <div id="leads-generated-chart"></div>
                                            </div>
                                            <!-- text-end -->
                                        </div>
                                        <!-- col-6 -->
                                    </div>
                                    <!-- row align-items-center -->
                                </div>
                                <!-- card-body -->
                            </div>
                            <!-- card -->
                        </div>
                        <!-- col -->
                        <!-- Qualified Leads -->
                        <div class="col-md-6 col-xxl-3">
                            <div class="card card-h-100">
                                <div class="card-body">
                                    <div class="row align-items-center">
                                        <div class="col-6">
                                            <h5 class="text-muted fs-sm text-uppercase text-truncate" title="Qualified Leads">Qualified Leads</h5>
                                            <div class="d-flex align-items-center gap-2 my-3">
                                                <div class="avatar-md flex-shrink-0">
                                                    <span class="avatar-title text-bg-light rounded-circle fs-22">
                                                        <i class="ti ti-user-check"></i>
                                                    </span>
                                                </div>
                                                <!-- avatar-md -->
                                                <h3 class="mb-0 fw-bold">
                                                    <span data-target="12.8">0</span>
                                                    k
                                                </h3>
                                            </div>
                                            <!-- stat-container -->
                                            <p class="mb-0 text-muted">
                                                <span class="text-danger me-2">
                                                    3.45%
                                                    <i class="ti ti-trending-down ms-1"></i>
                                                </span>
                                                <span class="text-nowrap">0.4k Down</span>
                                            </p>
                                        </div>
                                        <!-- col-6 -->
                                        <div class="col-6">
                                            <div class="d-flex justify-content-end">
                                                <div class="text-end" id="qualified-leads-chart"></div>
                                            </div>
                                            <!-- text-end -->
                                        </div>
                                        <!-- col-6 -->
                                    </div>
                                    <!-- row align-items-center -->
                                </div>
                                <!-- card-body -->
                            </div>
                            <!-- card -->
                        </div>
                        <!-- col -->
                        <!-- Deals Closed -->
                        <div class="col-md-6 col-xxl-3">
                            <div class="card card-h-100">
                                <div class="card-body">
                                    <div class="row align-items-center">
                                        <div class="col-6">
                                            <h5 class="text-muted fs-sm text-uppercase text-truncate" title="Deals Closed">Deals Closed</h5>
                                            <div class="d-flex align-items-center gap-2 my-3">
                                                <div class="avatar-md flex-shrink-0">
                                                    <span class="avatar-title text-bg-light rounded-circle fs-22">
                                                        <i class="ti ti-briefcase"></i>
                                                    </span>
                                                </div>
                                                <!-- avatar-md -->
                                                <h3 class="mb-0 fw-bold">
                                                    <span data-target="9.75">0</span>
                                                    k
                                                </h3>
                                            </div>
                                            <!-- stat-container -->
                                            <p class="mb-0 text-muted">
                                                <span class="text-success me-2">
                                                    2.94%
                                                    <i class="ti ti-trending-up ms-1"></i>
                                                </span>
                                                <span class="text-nowrap">1.1k Up</span>
                                            </p>
                                        </div>
                                        <!-- col-6 -->
                                        <div class="col-6">
                                            <div class="text-end">
                                                <div id="deals-closed-chart"></div>
                                            </div>
                                            <!-- text-end -->
                                        </div>
                                        <!-- col-6 -->
                                    </div>
                                    <!-- row align-items-center -->
                                </div>
                                <!-- card-body -->
                            </div>
                            <!-- card -->
                        </div>
                        <!-- col -->
                        <!-- Revenue Generated -->
                        <div class="col-md-6 col-xxl-3">
                            <div class="card card-h-100">
                                <div class="card-body">
                                    <div class="row align-items-center">
                                        <div class="col-6">
                                            <h5 class="text-muted fs-sm text-uppercase text-truncate" title="Revenue Generated">Revenue Generated</h5>
                                            <div class="d-flex align-items-center gap-2 my-3">
                                                <div class="avatar-md flex-shrink-0">
                                                    <span class="avatar-title text-bg-light rounded-circle fs-22">
                                                        <i class="ti ti-currency-dollar"></i>
                                                    </span>
                                                </div>
                                                <!-- avatar-md -->
                                                <h3 class="mb-0 fw-bold">
                                                    $
                                                    <span data-target="5.63">0</span>
                                                    M
                                                </h3>
                                            </div>
                                            <!-- stat-container -->
                                            <p class="mb-0 text-muted">
                                                <span class="text-success me-2">
                                                    4.21%
                                                    <i class="ti ti-trending-up ms-1"></i>
                                                </span>
                                                <span class="text-nowrap">$32.4k Up</span>
                                            </p>
                                        </div>
                                        <!-- col-6 -->
                                        <div class="col-6">
                                            <div class="text-end">
                                                <div id="revenue-generated-chart"></div>
                                            </div>
                                            <!-- text-end -->
                                        </div>
                                        <!-- col-6 -->
                                    </div>
                                    <!-- row align-items-center -->
                                </div>
                                <!-- card-body -->
                            </div>
                            <!-- card -->
                        </div>
                        <!-- col -->
                    </div>
                    <!-- row -->
                    <div class="row row-cols-xxl-4 row-cols-md-2 row-cols-1">
                        <!-- Revenue Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-header d-flex border-0 justify-content-between align-items-center">
                                    <h5 class="card-title mb-0">Total Revenue</h5>
                                    <span class="badge bg-success-subtle text-success">+8.2%</span>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h3 class="mb-1 fw-normal">
                                                $
                                                <span data-target="1240">0</span>
                                                K
                                            </h3>
                                            <p class="mb-0 text-muted">This Quarter</p>
                                        </div>
                                        <div class="text-end w-50">
                                            <div id="total-revenue-chart"></div>
                                        </div>
                                        <!-- text-end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Expenses Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-header d-flex border-0 justify-content-between align-items-center">
                                    <h5 class="card-title mb-0">Total Expenses</h5>
                                    <span class="badge bg-danger-subtle text-danger">-2.1%</span>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="text-end w-50">
                                            <div id="total-expenses-chart"></div>
                                        </div>
                                        <!-- text-end -->
                                        <div class="text-end ms-3">
                                            <h3 class="mb-1 fw-normal">
                                                $
                                                <span data-target="840">0</span>
                                                K
                                            </h3>
                                            <p class="mb-0 text-muted">This Quarter</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Net Profit Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-header d-flex border-0 justify-content-between align-items-center">
                                    <h5 class="card-title mb-0">Net Profit</h5>
                                    <span class="badge bg-info-subtle text-info">Stable</span>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h3 class="mb-1 fw-normal">
                                                $
                                                <span data-target="400">0</span>
                                                K
                                            </h3>
                                            <p class="mb-0 text-muted">This Quarter</p>
                                        </div>
                                        <div class="text-end w-50">
                                            <div id="net-profit-chart"></div>
                                        </div>
                                        <!-- text-end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Cash Flow Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-header d-flex border-0 justify-content-between align-items-center">
                                    <h5 class="card-title mb-0">Cash Flow</h5>
                                    <span class="badge bg-warning-subtle text-warning">+5.6%</span>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="text-end w-50">
                                            <div id="cash-flow-chart"></div>
                                        </div>
                                        <!-- text-end -->
                                        <div class="text-end ms-3">
                                            <h3 class="mb-1 fw-normal">
                                                $
                                                <span data-target="720">0</span>
                                                K
                                            </h3>
                                            <p class="mb-0 text-muted">This Quarter</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                    <div class="row">
                        <div class="col-xxl-3 col-xl-6">
                            <div class="card card-h-100">
                                <div class="card-header justify-content-between">
                                    <h4 class="card-title">Project Status Breakdown</h4>
                                    <div class="dropdown ms-auto">
                                        <a class="btn btn-sm btn-default btn-icon" data-bs-toggle="dropdown" href="#">
                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-eye me-2"></i>
                                                    View All Status Details
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-filter-2 me-2"></i>
                                                    Filter by Status
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-calendar me-2"></i>
                                                    Change Date Range
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-download me-2"></i>
                                                    Export Breakdown
                                                </a>
                                            </li>
                                            <li><hr class="dropdown-divider" /></li>
                                            <li>
                                                <a class="dropdown-item text-danger" href="#">
                                                    <i class="ti ti-refresh me-2"></i>
                                                    Reset Status View
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="card-body pt-0">
                                    <div class="apex-charts" id="project-status-chart"></div>
                                    <div class="row mt-2">
                                        <div class="col">
                                            <div class="d-flex justify-content-between align-items-center p-1">
                                                <div>
                                                    <i class="ti ti-circle-filled fs-12 align-middle me-1 text-secondary"></i>
                                                    <span class="align-middle fw-semibold">Completed</span>
                                                </div>
                                                <span class="fw-semibold text-muted float-end">
                                                    <i class="ti ti-chevron-down text-danger"></i>
                                                    965
                                                </span>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center p-1">
                                                <div>
                                                    <i class="ti ti-circle-filled fs-12 align-middle me-1 text-warning"></i>
                                                    <span class="align-middle fw-semibold">In Progress</span>
                                                </div>
                                                <span class="fw-semibold text-muted float-end">
                                                    <i class="ti ti-chevron-up text-success"></i>
                                                    75
                                                </span>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="d-flex justify-content-between align-items-center p-1">
                                                <div>
                                                    <i class="ti ti-circle-filled fs-12 align-middle me-1 text-secondary"></i>
                                                    <span class="align-middle fw-semibold">Yet to Start</span>
                                                </div>
                                                <span class="fw-semibold text-muted float-end">
                                                    <i class="ti ti-chevron-up text-success"></i>
                                                    102
                                                </span>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center p-1">
                                                <div>
                                                    <i class="ti ti-circle-filled fs-12 align-middle me-1 text-danger"></i>
                                                    <span class="align-middle fw-semibold">Cancelled</span>
                                                </div>
                                                <span class="fw-semibold text-muted float-end">
                                                    <i class="ti ti-chevron-down text-danger"></i>
                                                    96
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                        <div class="col-xxl-3 col-xl-6 order-xxl-1">
                            <div class="card card-h-100">
                                <div class="card-header justify-content-between">
                                    <h4 class="card-title">Store Performance Analytics</h4>
                                    <div>
                                        <a class="btn btn-sm btn-default" href="#">
                                            <i class="ti ti-refresh me-1"></i>
                                            Refresh
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="apex-charts" id="total-sales-chart"></div>
                                    </div>
                                    <div class="text-center">
                                        <span class="badge badge-outline-light text-dark p-1 px-2 rounded-pill fs-12">
                                            <i class="ti ti-star-filled text-success me-1"></i>
                                            GOOD SALES
                                        </span>
                                    </div>
                                    <div class="table-responsive mt-3">
                                        <table class="table table-sm table-nowrap table-borderless table-centered mb-0">
                                            <thead class="bg-light bg-opacity-50 thead-sm">
                                                <tr class="text-uppercase fs-xxs">
                                                    <th>Page</th>
                                                    <th>Views</th>
                                                    <th>B. Rate</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>
                                                        <a class="text-muted" href="javascript:void(0);">/paces/dashboard-analytics</a>
                                                    </td>
                                                    <td>25</td>
                                                    <td>87.5%</td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <a class="text-muted" href="javascript:void(0);">/paces/dashboard-crm</a>
                                                    </td>
                                                    <td>15</td>
                                                    <td>21.48%</td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <a class="text-muted" href="javascript:void(0);">/ubold/dashboard</a>
                                                    </td>
                                                    <td>10</td>
                                                    <td>63.59%</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <!-- end .table-responsive-->
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                        <div class="col-xxl-6 col-xl-12">
                            <div class="card card-h-100">
                                <div class="card-header justify-content-between">
                                    <h4 class="card-title">Projects Performance Overview</h4>
                                    <div class="dropdown ms-auto">
                                        <a class="btn btn-sm btn-default btn-icon" data-bs-toggle="dropdown" href="#">
                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-chart-histogram me-2"></i>
                                                    View Detailed Report
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-filter-2 me-2"></i>
                                                    Filter by Project
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-calendar me-2"></i>
                                                    Select Date Range
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-download me-2"></i>
                                                    Export as CSV
                                                </a>
                                            </li>
                                            <li>
                                                <hr class="dropdown-divider" />
                                            </li>
                                            <li>
                                                <a class="dropdown-item text-danger" href="#">
                                                    <i class="ti ti-refresh me-2"></i>
                                                    Reset Analytics
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row text-center g-2">
                                        <div class="col">
                                            <div class="border bg-light-subtle border-dashed border-light p-2 rounded">
                                                <h4><span data-target="7,845">0</span></h4>
                                                <p class="mb-0 text-muted">Number of Projects</p>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="border bg-light-subtle border-dashed border-light p-2 rounded">
                                                <h4><span data-target="289">0</span></h4>
                                                <p class="mb-0 text-muted">Active Projects</p>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="border bg-light-subtle border-dashed border-light p-2 rounded">
                                                <h4>
                                                    $
                                                    <span data-target="982.5">0</span>
                                                    k
                                                </h4>
                                                <p class="mb-0 text-muted">Revenue</p>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="border bg-light-subtle border-dashed border-light p-2 rounded">
                                                <h4>
                                                    ~
                                                    <span data-target="12,559">0</span>
                                                    h
                                                </h4>
                                                <p class="mb-0 text-muted">Working Hours</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div dir="ltr">
                                        <div class="apex-charts" id="dash-projects-overviews"></div>
                                    </div>
                                </div>
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                    <div class="row">
                        <div class="col-xxl-6">
                            <div class="card card-h-100">
                                <div class="card-header border-dashed card-tabs">
                                    <div class="flex-grow-1">
                                        <h4 class="card-title">
                                            Sales Report
                                            <span class="text-muted fs-base fw-normal">(25822 Orders)</span>
                                        </h4>
                                    </div>
                                    <ul class="nav nav-tabs nav-justified card-header-tabs nav-bordered">
                                        <li class="nav-item">
                                            <a aria-expanded="false" class="nav-link" data-bs-toggle="tab" href="#!">
                                                <span class="d-md-none d-block">1D</span>
                                                <span class="d-none d-md-block">Today</span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a aria-expanded="true" class="nav-link active" data-bs-toggle="tab" href="#!">
                                                <span class="d-md-none d-block">1M</span>
                                                <span class="d-none d-md-block">Monthly</span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a aria-expanded="false" class="nav-link" data-bs-toggle="tab" href="#!">
                                                <span class="d-md-none d-block">1Y</span>
                                                <span class="d-none d-md-block">Annual</span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="card-body p-0">
                                    <div class="bg-light bg-opacity-25 border-bottom border-dashed">
                                        <div class="row text-center">
                                            <div class="col-sm-4">
                                                <p class="text-muted mt-3 mb-1">Revenue</p>
                                                <h4 class="mb-3">
                                                    <i class="ti ti-wallet text-success me-1"></i>
                                                    <span>
                                                        $
                                                        <span data-target="78,224.68"></span>
                                                    </span>
                                                </h4>
                                            </div>
                                            <div class="col-sm-4">
                                                <p class="text-muted mt-3 mb-1">Orders</p>
                                                <h4 class="mb-3">
                                                    <i class="ti ti-basket text-success me-1"></i>
                                                    <span><span data-target="8541"></span></span>
                                                </h4>
                                            </div>
                                            <div class="col-sm-4">
                                                <p class="text-muted mt-3 mb-1">Growth Rate</p>
                                                <h4 class="mb-3">
                                                    <i class="ti ti-trending-up text-success me-1"></i>
                                                    <span>
                                                        <span data-target="25.3"></span>
                                                        %
                                                    </span>
                                                </h4>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="p-3 pt-1">
                                        <div class="dash-item-overlay d-none d-md-block" dir="ltr">
                                            <h5>Today's Earning: $8,975.30</h5>
                                            <p class="text-muted mb-0 mt-2">Property PS007 is not receiving hits. Either your site is not receiving any sessions.</p>
                                        </div>
                                        <div dir="ltr">
                                            <div class="apex-charts" id="sales-report-chart"></div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                        <div class="col-xxl-6">
                            <div class="card card-h-100">
                                <div class="card-header border-0 justify-content-between">
                                    <h4 class="card-title">Financial Overview</h4>
                                    <div class="dropdown ms-auto">
                                        <a class="btn btn-sm btn-default btn-icon" data-bs-toggle="dropdown" href="#">
                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-refresh me-2"></i>
                                                    Refresh Data
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-chart-bar me-2"></i>
                                                    View Analytics
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-filter-2 me-2"></i>
                                                    Filter Report
                                                </a>
                                            </li>
                                            <li>
                                                <hr class="dropdown-divider" />
                                            </li>
                                            <li>
                                                <a class="dropdown-item text-danger" href="#">
                                                    <i class="ti ti-download me-2"></i>
                                                    Export Data
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="bg-light bg-opacity-40">
                                        <div class="row text-center">
                                            <div class="col">
                                                <p class="text-muted mt-3 mb-1">Revenue</p>
                                                <h4 class="mb-3">
                                                    <span class="ti ti-square-rounded-arrow-down text-success me-1"></span>
                                                    <span>
                                                        $
                                                        <span data-target="29.56">0</span>
                                                        k
                                                    </span>
                                                </h4>
                                            </div>
                                            <div class="col">
                                                <p class="text-muted mt-3 mb-1">Expenses</p>
                                                <h4 class="mb-3">
                                                    <span class="ti ti-square-rounded-arrow-up text-danger me-1"></span>
                                                    <span>
                                                        $
                                                        <span data-target="15.08">0</span>
                                                        k
                                                    </span>
                                                </h4>
                                            </div>
                                            <div class="col">
                                                <p class="text-muted mt-3 mb-1">Investment</p>
                                                <h4 class="mb-3">
                                                    <span class="ti ti-chart-infographic me-1"></span>
                                                    <span>
                                                        $
                                                        <span data-target="3.67">0</span>
                                                        k
                                                    </span>
                                                </h4>
                                            </div>
                                            <div class="col">
                                                <p class="text-muted mt-3 mb-1">Savings</p>
                                                <h4 class="mb-3">
                                                    <span class="ti ti-pig me-1"></span>
                                                    <span>
                                                        $
                                                        <span data-target="6.72">0</span>
                                                        k
                                                    </span>
                                                </h4>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="p-2">
                                        <div dir="ltr">
                                            <div class="apex-charts" id="financial-overview-chart"></div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Apex Chart js -->
        <script src="/plugins/apexcharts/apexcharts.min.js"></script>
        <!-- Chart Widgets js -->
        <script src="/js/pages/widgets-charts.js"></script>
    </body>
</html>
