<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ArticleModel;
use App\Services\ArticleService;
use App\Services\PriceService;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\API\ResponseTrait;


class Article extends BaseController
{
    use ResponseTrait;
    private ArticleModel $articleModel;

    public function __construct()
    {
        $this->articleModel = new ArticleModel();
    }
    public function index(): ResponseInterface
    {
        $articles = ArticleService::getArticles();

        return $this->respond($articles);
    }

    public function show($id):ResponseInterface
    {
        $article = $this->articleModel
            ->select([
                "id",
                "articles.name",
                "cost",
                "category",
                "id as price",
                "created_at",
                "updated_at",
                "deleted_at",
                "paused"
            ])
            ->find($id);
        return $this->respond($article);
    }


    public function create():ResponseInterface
    {
        $article = new \App\Entities\Article( [
            "name"=>$this->request->getPost("name"),
            "cost"=>$this->request->getPost("cost"),
            "price"=>$this->request->getPost("price")[0]["amount"],
            "category"=>$this->request->getPost("category"),
        ]);

        try {
            $saved  = $this->articleModel->save($article);
        }catch (\ReflectionException $e){
            return $this->fail($e->getMessage());
        }

        return $saved ?
            $this->respondCreated( $this->articleModel->find($this->articleModel->getInsertID())) :
            $this->fail($this->articleModel->errors());
    }



    public function list()
    {
        $data['path'] = 'Artículos';
        return view('article/list', $data);
    }

    public function update($id): ResponseInterface
    {
        $article = $this->articleModel->find($id);
        $article->fill($this->request->getRawInput());
        try {
            $updated = $this->articleModel->save($article);
        } catch (\ReflectionException $e) {
            return $this->fail($e->getMessage());
        }
        return $updated ? $this->respondUpdated($article):$this->fail($this->articleModel->errors());
    }

    public function delete($id): ResponseInterface
    {
        return $this->respondDeleted($this->articleModel->delete($id));
    }
}
