<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Entities\Payment;
use App\Models\SaleModel;
use App\Services\SaleItemService;
use CodeIgniter\API\ResponseTrait;
use CodeIgniter\HTTP\ResponseInterface;
use Ramsey\Uuid\Uuid;
use Spipu\Html2Pdf\Exception\Html2PdfException;
use Spipu\Html2Pdf\Html2Pdf;
use CodeIgniter\I18n\Time;

class Sale extends BaseController
{
    use ResponseTrait;

    private SaleModel $saleModel;

    public function __construct()
    {
        $this->saleModel = new SaleModel();
    }

    public function index()
    {
        //list all sales
        $sales = $this->saleModel->findAll();

        return $this->respond($sales);
    }

    public function create()
    {
        $itemService = new SaleItemService();
        $sale = (object) $this->request->getPost();
        $sale = new \App\Entities\Sale([
            "uuid" => Uuid::uuid6()->toString(),
            //"store"=> session("store")->id,
            "items"=>$sale->items,
            "payment_type"=>$sale->type,
            "aut" => $sale->aut,
            "discount"=>$sale->discount,
            "amount"=> $sale->amount,
            "cash"=> $sale->payment['received'],
            "created_by" =>auth()->user()->id,
        ]);
        $sale->payment = $this->request->getPost("payment");

        try {
            $save = $this->saleModel->save($sale);
            $sale->id = $this->saleModel->getInsertID();
            $itemService->setSaleItems($sale, $this->request->getPost("cart"));
        } catch (\ReflectionException $e) {
        }
        if($save)
        {
            $currentSale =  $sale;
            $payment = new Payment();
            $payment->fill([
                "sale"=>$currentSale->id,
                "payment_type"=>$sale->payment_type,
                "amount"=>$currentSale->amount,
                "cash"=>$sale->payment["received"],
                "cashback"=>$sale->payment["cashback"],
                "created_by"=>auth()->user()->id??0
            ]);
            $paid = $currentSale->pay($payment);

        }

        return $save ?
            $this->respondCreated($this->saleModel->find($this->saleModel->getInsertID())) :
            $this->fail($this->saleModel->errors());
    }

    public function list()
    {
        return view('sale/list');
    }
    public function tickets(): string|ResponseInterface

    {
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '-1');
        $start = $this->request->getGet("start") ?? Time::today()->toDateString();
        $end = $this->request->getGet("end") ?? Time::today()->toDateString();
        helper("number");
        helper("inflector");
        $settings = service("settings");
        $sales = $this->saleModel
            ->select("uuid")
            ->where([
                "sales.created_at >="=> $start,
                "sales.created_at <="=> $end,
            ])->findAll();

        $html ='';
        foreach($sales as $sale){



            $select = [
                "sales.id",
                "sales.uuid",
                "payment_type",
                "sales.aut authorization",
                "sales.discount ",
                "sales.amount",
                "sales.cash",
                "sales.delivery",
                "sales.created_by",
                "sales.created_at",
                "sales.store",
                "st.name store_name",
                "c.id customer",
                "concat_ws(' ',c.name,c.last_name) customer_name",
                "c.address customer_address",


            ];
            $sales = $this->saleModel
                ->select($select)
                ->where(["uuid"=>$sale->uuid])
                ->join("customers c ","c.id = sales.customer")
                ->join("users u","u.id = sales.created_by")
                ->join("stores st", "st.id = sales.store")
                ->first();
            if(!$sales instanceof \App\Entities\Sale){
                return $this->failNotFound();
            }
            $company->store = model(StoreModel::class)->find($sales->store);

            $saleItems = model(SaleItemsModel::class)->where(["sale"=>$sales->id])
                ->join("items i","i.id = sale_items.item")
                ->findAll();
            $payments = model(PaymentModel::class)->where(["sale"=>$sales->id])->findAll();

            $sales->payment= count($payments)>1 ? $payments:(!empty($payments)?$payments[0]:["cash"=>0,"cashback"=>0]);
            $sales->amount_letter = $this->getLetterCurrency($sales->amount);

            $html .= view("components/sale/ticket",[
                "sales"=>$sales,
                "items"=>$saleItems,
                "company"=>$company,
                "payments" =>$this->payment_types,

                "user"=> auth()->getProvider()->findById($sales->created_by)
            ]);

        }
       // $pdf = new Html2Pdf('P',[58,350],'es');

        //$pdf->writeHTML($html);

//        echo $html;exit;

        $this->response->setHeader("Content-Type","application/pdf");
        try {
          //  return $pdf->output();
        } catch (Html2PdfException $e) {
            log_message("error",$e->getMessage());
        }
        return $html;
    }
    public function ticket($uuid): string|ResponseInterface
    {
        helper("number");
        helper("inflector");
        $select = [
            "sales.id",
            "sales.uuid",
            "payment_type",
            "sales.aut authorization",
            "sales.items",
            "sales.discount ",
            "sales.amount",
            "sales.cash",
            "sales.created_by",
            "sales.created_at",
            "sales.store",
            "sales.id as sale_items"
        ];
        $sales = $this->saleModel
            ->select($select)
            ->where(["uuid"=>$uuid])
            ->join("users u","u.id = sales.created_by","left")
            ->first();
        if(!$sales instanceof \App\Entities\Sale){
            return $this->failNotFound();
        }
        $html  = view("ticket/saleTicket",[
            "sales"=>$sales,
            //"user"=> auth()->getProvider()->findById($sales->created_by)
        ]);

        return $html;
    }

    public function delete($id)
    {
        return $this->respondDeleted($this->saleModel->delete($id));
    }


}
