<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class ArticleTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id"=>[
                "type"=>"INT",
                "constraint"=>11,
                "auto_increment"=>true,
                "unsigned"=>true,
            ],
            "name"=>[
                "type"=>"varchar",
                "constraint"=>150 ,
                "null"=>false,
            ],
            "cost"=> [
                "type"=>"decimal",
                "constraint"=>"10,2",
                "null"=>true,
            ],
            "category"=>[
                'type' => 'ENUM("dulce","vitrina","croissant", "salado", "bebidas", "otros")',
                'default' => 'dulce',
                'null' => FALSE,
            ],
            "price"=>[
                "type"=>"decimal",
                "constraint"=>"10,2",
                "null"=>true,
            ],
            "created_at"=>[
                "type"=>"DATETIME",
                "default"=>new RawSql("CURRENT_TIMESTAMP")
            ],
            "updated_at"=>[
                "type"=>"datetime",
                "null"=>true
            ],
            "deleted_at"=>[
                "type"=>"datetime",
                "null"=>true
            ]
        ]);
        $this->forge->addPrimaryKey("id")
            ->createTable("articles",true,["ENGINE"=>"InnoDB"]);
    }

    public function down()
    {
        $this->forge->dropTable('articles');
    }
}
