<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class SaleTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id" => [
                "type"=>"int",
                "constraint",11,
                "auto_increment"=>true,
                "unsigned"=>true,
            ],
            "uuid"=>[
                "type"=> "varchar",
                "constraint"=> 36
            ],
            "store"=>[
                "type"=>"int",
                "constraint"=>11
            ],
            "items"=>[
                "type"=>"int",
                "constraint"=>6
            ],
            "payment_type"=>[
                "type"=> "ENUM",
                "constraint"=>['cash','card','transfer','credit'],
                "default"=>'cash'
            ],
            "aut"=>[
                "type"=>"int",
                "constraint"=>11,
                "null"=>true
            ],
            "discount"=>[
                "type"=>"decimal",
                "constraint"=>"10,2",
                "null"=>true,
            ],
            "amount" =>[
                "type"=>"decimal",
                "constraint"=>"10,2",

            ],
            "comments"=>[
                "type"=>"varchar",
                "constraint"=>250,
                "null"=>true
            ],
            "document"=>[
                "type"  => "varchar",
                "constraint"=>250,
                "null"=>true
            ],
            "created_by"=>[
                "type" =>"INT",
                "constraint"=>11,
            ],
            "created_at"=>[
                "type" =>"DATETIME",
                "default"=>new RawSql("CURRENT_TIMESTAMP")
            ],
            "updated_at"=>[
                "type" =>"DATETIME",
                "null"=>true
            ],
            "deleted_at"=>[
                "type" =>"DATETIME",
                "null"=>true
            ]

        ])
            ->addPrimaryKey("id")
            ->createTable("sales");
    }

    public function down()
    {
        $this->forge->dropTable('sales');
    }
}
