<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class ArticlePricesTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id"=>[
                "type"=>"INT",
                "constraint"=>11,
                "unsigned"=>true,
                "auto_increment"=>true
            ],
            "store"=>[
                "type"=>"INT",
                "constraint"=>11,
                "unsigned"=>true,
                "null"=>true,
            ],
            "article"=>[
                "type"=>"INT",
                "constraint"=>11,
                "unsigned"=>true,
                "null"=>true,
            ],
            "name"=>[
                "type"=>"VARCHAR",
                "constraint"=>255,
                "null"=>true
            ],
            "amount"=>[
                "type"=>"decimal",
                "constraint"=>"11,2",
                "null"=>true,
                "default"=>0,
            ]
        ])->addPrimaryKey("id")
            ->addForeignKey("store","stores","id","CASCADE","SET NULL")
            ->addForeignKey("article","articles","id","CASCADE","SET NULL")
            ->createTable("prices",true,["ENGINE"=>"InnoDB"]);
    }

    public function down()
    {
        $this->forge->dropTable("prices");
    }
}
