<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class SaleItems extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id"=>[
                "type"=>"INT",
                "constraint"=>11,
                "unsigned"=>true,
                "auto_increment"=>true
            ],
            "sale"=>[
                "type"=>"INT",
                "constraint"=>11,
                "unsigned"=>true,
                "null"=>true,
            ],
            "store"=>[
                "type"=>"INT",
                "constraint"=>11,
                "unsigned"=>true,
                "null"=>true,
            ],
            "article"=>[
                "type"=>"INT",
                "constraint"=>11,
                "unsigned"=>true,
                "null"=>true,
            ],
            "qty"=>[
                "type"=>"INT",
            ],
            "sale_price"=>[
                "type"=>"DECIMAL",
                "constraint"=>"10,2",
            ],
            "unit_price"=>[
                "type"=>"DECIMAL",
                "constraint"=>"10,2",
            ],
            "final_price"=>[
                "type"=>"DECIMAL",
                "constraint"=>"10,2",
            ]
        ])->addPrimaryKey("id")
            ->addForeignKey("sale","sales","id")
            ->addForeignKey("article","articles","id")
            ->createTable("sale_items",true,["ENGINE"=>"InnoDB"]);
    }

    public function down()
    {
        $this->forge->dropTable("sale_items");
    }
}
