<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class AddReceivedAmountSale extends Migration
{
    public function up()
    {
        $fields = [
            "cash"=>[
                "type"=>"decimal",
                "constraint"=>"10,2",
                "after"=>"amount",
                "null"=>true]
        ];
        $this->forge->addColumn('sales', $fields);
    }

    public function down()
    {
        $this->forge->dropColumn('sales', 'cash');
    }
}
