<?php

namespace App\Models\Casts;

use App\Entities\SaleItem;
use App\Models\SaleItemModel;
use CodeIgniter\Datacaster\Cast\BaseCast;
class SaleItemsCast extends BaseCast
{
    public static function get(mixed $value, array $params = [], ?object $helper = null): mixed
    {
        return model(SaleItemModel::class)
            ->select([
                "id",
                "article as article_name",
                "qty as qty",
                "sale_price",
                "unit_price",
                "final_price"
            ])
            ->where("sale", $value)->findAll();
    }

}