<?php

namespace App\Services;

use App\Models\ArticleModel;

class ArticleService
{

    public static function getArticles($paused = false): array
    {
        $model = model(ArticleModel::class);
        $articles = $model
            ->select([
                "id",
                "name",
                "cost",
                "category",
                "price",
                "created_at",
                "updated_at",
                "deleted_at",
                "paused"
            ]);

        $paused ? $articles ->where('paused', 0) : null;

        return $articles->findAll();
    }
}