<?= $this->extend('app/layout') ?>

<?= $this->section('viewStyles') ?>
<link rel="stylesheet" href="/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
<link rel="stylesheet" href="/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
<link rel="stylesheet" href="/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.css" />
<link rel="stylesheet" href="/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" />
<link rel="stylesheet" href="/assets/vendor/libs/bootstrap-select/bootstrap-select.css" />
<link rel="stylesheet" href="/assets/vendor/libs/sweetalert2/sweetalert2.css" />
<?= $this->endSection() ?>


<?= $this->section('content') ?>
    <?=$this->include('expense/form')?>

    <?=$this->include('expense/datatable')?>

<?= $this->endSection() ?>


<?= $this->section('viewScripts') ?>
<script src="/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
<script src="/assets/vendor/libs/bootstrap-select/bootstrap-select.js"></script>
<script src="/assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
<script>
    console.log('Expense JS loaded');
    var dt_basic_table = $('.datatables-basic');
    // Article form
    $("form").on("submit",function(e){
        e.preventDefault();
        let expenseData = $(this).serializeArray();

        $.ajax({
            method: "POST",
            url: "/expense",
            dataType: "JSON",
            data: expenseData,
            statusCode:{
                201:toggleLoading,
                500:errorFromServer,
                400:badRequest
            }
        }).done(function(expense){
            if(expense.id != null){
                toggleLoading();
                toastAlert('success','Gasto registrado', 'En breve se actualizará la tabla');
                $('#newExpenseForm')[0].reset();
                dt_basic.ajax.reload();
            }else {
                toastAlert('error', 'Algo salio mal', 'Por favor, intenta de nuevo');
            }
        });
    });

    //Datatable
    if (dt_basic_table.length) {
        dt_basic = dt_basic_table.DataTable({
            ajax: {
                url: '/expense',
                dataSrc: ""
            },
            columns: [
                { data: '' },
                { data: 'id' },
                { data: 'id' },
                { data: '' },
                { data: 'description' },
                { data: 'amount' },
                { data: 'category' },
                { data: '' }
            ],
            columnDefs: [
                {
                    // For Responsive
                    className: 'control',
                    orderable: false,
                    searchable: false,
                    responsivePriority: 2,
                    targets: 0,
                    render: function (data, type, full, meta) {
                        return '';
                    }
                },
                {
                    // For Checkboxes
                    targets: 1,
                    orderable: false,
                    searchable: false,
                    responsivePriority: 3,
                    checkboxes: true,
                    render: function () {
                        return '<input type="checkbox" class="dt-checkboxes form-check-input">';
                    },
                    checkboxes: {
                        selectAllRender: '<input type="checkbox" class="form-check-input">'
                    }
                },
                {
                    targets: 2,
                    searchable: false,
                    visible: false
                },
                {
                    responsivePriority: 1,
                    targets: 4
                },
                {
                    // Date
                    targets: 3,
                    title: 'Fecha',
                    orderable: true,
                    searchable: true,
                    render: function (data, type, full, meta) {
                        $date = full.created_at.date;
                        $humanDate = $date.split(' ')[0]
                        return (`${$humanDate}`);
                    }
                },
                {
                    // Actions
                    targets: -1,
                    title: 'Acciones',
                    orderable: false,
                    searchable: false,
                    render: function (data, type, full, meta) {
                        return (
                            `<a href="javascript:;" onclick="wip()" class="btn btn-sm btn-text-secondary rounded-pill btn-icon item-edit"><i class="ri-pencil-fill"></i></a>
                            <a href="javascript:;" onclick="deleteExpense(${full.id})" class="btn btn-sm btn-text-secondary rounded-pill btn-icon item-edit"><i class="ri-delete-bin-6-fill"></i></a>
                            `
                        );
                    }
                }
            ],
            order: [[2, 'desc']],
            dom: '<"card-header flex-column flex-md-row border-bottom"<"head-label text-center"><"dt-action-buttons text-end pt-3 pt-md-0"B>><"row"<"col-sm-12 col-md-6 mt-5 mt-md-0"l><"col-sm-12 col-md-6 d-flex justify-content-center justify-content-md-end"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
            displayLength: 7,
            lengthMenu: [7, 10, 25, 50, 75, 100],
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-label-primary dropdown-toggle me-4 waves-effect waves-light',
                    text: '<i class="ri-external-link-line me-sm-1"></i> <span class="d-none d-sm-inline-block">Exportar</span>',
                    buttons: [
                        {
                            extend: 'csv',
                            text: '<i class="ri-file-text-line me-1" ></i>CSV',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: [3, 4, 5, 6, 7]
                            }
                        },
                        {
                            extend: 'pdf',
                            text: '<i class="ri-file-pdf-line me-1"></i>PDF',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: [3, 4, 5, 6, 7]
                            }
                        },
                    ]
                }
            ],
            responsive: {
                details: {
                    display: $.fn.dataTable.Responsive.display.modal({
                        header: function (row) {
                            var data = row.data();
                            return 'Detalles del gasto';
                        }
                    }),
                    type: 'column',
                    renderer: function (api, rowIdx, columns) {
                        var data = $.map(columns, function (col, i) {
                            return col.title !== '' // ? Do not show row in modal popup if title is blank (for check box)
                                ? '<tr data-dt-row="' +
                                col.rowIndex +
                                '" data-dt-column="' +
                                col.columnIndex +
                                '">' +
                                '<td>' +
                                col.title +
                                ':' +
                                '</td> ' +
                                '<td>' +
                                col.data +
                                '</td>' +
                                '</tr>'
                                : '';
                        }).join('');

                        return data ? $('<table class="table"/><tbody />').append(data) : false;
                    }
                }
            }
        });
        $('div.head-label').html('<h5 class="card-title mb-0">Relación de gastos</h5>');
    }

    function deleteExpense(expense)
    {
        Swal.fire({
            title: '¿Estás seguro?',
            text: "No serás capaz de recuperar este gasto",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar gasto!',
            cancelButtonText: 'Cancelar',
            customClass: {
                confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                cancelButton: 'btn btn-outline-secondary waves-effect'
            },
            buttonsStyling: false
        }).then(function (result) {
            if (result.isConfirmed) {
                $.ajax({
                    method: 'POST',
                    url: '/expense/'+expense,
                    data: {
                        '_method': 'DELETE'
                    },
                    dataType: 'JSON'
                }).done(function(response){
                    toastAlert('info', 'Gasto eliminado', 'Mejor, más dinero para todos');
                    dt_basic.ajax.reload();
                })
            }
        });
    }
</script>
<?= $this->endSection() ?>
