<?= $this->extend('app/layout') ?>

<?= $this->section('viewStyles') ?>
<link rel="stylesheet" href="/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
<link rel="stylesheet" href="/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
<link rel="stylesheet" href="/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.css" />
<link rel="stylesheet" href="/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" />
<link rel="stylesheet" href="/assets/vendor/libs/sweetalert2/sweetalert2.css" />
<?= $this->endSection() ?>


<?= $this->section('content') ?>
    <?=$this->include('sale/datatable')?>

<?= $this->endSection() ?>


<?= $this->section('viewScripts') ?>
<script src="/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
<script src="/assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
<script>
    console.log('Sale JS loaded');
    var dt_basic_table = $('.datatables-basic');

    $(function(){
        $("form").on("submit",function(e){
            e.preventDefault();
        });
    });

    //Datatable
    if (dt_basic_table.length) {
        dt_basic = dt_basic_table.DataTable({
            ajax: {
                url: '/sale',
                dataSrc: ""
            },
            columns: [
                { data: '' },
                { data: 'id' },
                { data: 'id' },
                { data: '' },
                { data: 'items' },
                { data: 'amount' },
                { data: 'discount' },
                { data: '' },
                { data: '' }
            ],
            columnDefs: [
                {
                    // For Responsive
                    className: 'control',
                    orderable: false,
                    searchable: false,
                    responsivePriority: 2,
                    targets: 0,
                    render: function (data, type, full, meta) {
                        return '';
                    }
                },
                {
                    // For Checkboxes
                    targets: 1,
                    orderable: false,
                    searchable: false,
                    responsivePriority: 3,
                    checkboxes: true,
                    render: function () {
                        return '<input type="checkbox" class="dt-checkboxes form-check-input">';
                    },
                    checkboxes: {
                        selectAllRender: '<input type="checkbox" class="form-check-input">'
                    }
                },
                {
                    targets: 2,
                    searchable: false,
                    visible: false
                },
                {
                    responsivePriority: 1,
                    targets: 4
                },
                {
                    // Actions
                    targets: -1,
                    title: 'Acciones',
                    orderable: false,
                    searchable: false,
                    render: function (data, type, full, meta) {
                        return (
                            `<a href="javascript:;" onclick="wip()" class="btn btn-sm btn-text-secondary rounded-pill btn-icon item-edit"><i class="ri-pencil-fill"></i></a>
                            <a href="/ticket/${full.uuid}" target="_blank"  class="btn btn-sm btn-text-secondary rounded-pill btn-icon item-edit"><i class="ri-receipt-fill"></i></a>
                            <a href="javascript:;" onclick="deleteSale(${full.id})" class="btn btn-sm btn-text-secondary rounded-pill btn-icon item-edit"><i class="ri-delete-bin-6-fill"></i></a>
                            `
                        );
                    }
                },
                {
                    // Date
                    targets: 3,
                    title: 'Fecha',
                    orderable: true,
                    searchable: true,
                    render: function (data, type, full, meta) {
                        $date = full.created_at.date;
                        return (`${$date.split(' ')[0]}`);
                    }
                },
                {
                    // Payment Method
                    targets: 7,
                    title: 'Método',
                    orderable: true,
                    searchable: true,
                    render: function (data, type, full, meta) {
                        const translationMap = {
                            cash: "Efectivo",
                            card: "Tarjeta",
                            transfer: "Transferencia",
                        };
                        return translationMap[full.payment_type];
                    }
                },
            ],
            order: [[2, 'desc']],
            dom: '<"card-header flex-column flex-md-row border-bottom"<"head-label text-center"><"dt-action-buttons text-end pt-3 pt-md-0"B>><"row"<"col-sm-12 col-md-6 mt-5 mt-md-0"l><"col-sm-12 col-md-6 d-flex justify-content-center justify-content-md-end"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
            displayLength: 10,
            lengthMenu: [10, 25, 50, 75, 100],
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-label-primary dropdown-toggle me-4 waves-effect waves-light',
                    text: '<i class="ri-external-link-line me-sm-1"></i> <span class="d-none d-sm-inline-block">Exportar</span>',
                    buttons: [
                        {
                            extend: 'csv',
                            text: '<i class="ri-file-text-line me-1" ></i>CSV',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: [3, 4, 5, 6, 7]
                            }
                        },
                        {
                            extend: 'pdf',
                            text: '<i class="ri-file-pdf-line me-1"></i>PDF',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: [3, 4, 5, 6, 7]
                            }
                        },
                    ]
                }
            ],
            responsive: {
                details: {
                    display: $.fn.dataTable.Responsive.display.modal({
                        header: function (row) {
                            var data = row.data();
                            return 'Detalles del artículo';
                        }
                    }),
                    type: 'column',
                    renderer: function (api, rowIdx, columns) {
                        var data = $.map(columns, function (col, i) {
                            return col.title !== '' // ? Do not show row in modal popup if title is blank (for check box)
                                ? '<tr data-dt-row="' +
                                col.rowIndex +
                                '" data-dt-column="' +
                                col.columnIndex +
                                '">' +
                                '<td>' +
                                col.title +
                                ':' +
                                '</td> ' +
                                '<td>' +
                                col.data +
                                '</td>' +
                                '</tr>'
                                : '';
                        }).join('');

                        return data ? $('<table class="table"/><tbody />').append(data) : false;
                    }
                }
            }
        });
        $('div.head-label').html('<h5 class="card-title mb-0">Relación de ventas</h5>');
    }


    function deleteSale(sale)
    {
        Swal.fire({
            title: '¿Estás seguro?',
            text: "No serás capaz de recuperar esta venta",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar venta!',
            cancelButtonText: 'Cancelar',
            customClass: {
                confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                cancelButton: 'btn btn-outline-secondary waves-effect'
            },
            buttonsStyling: false
        }).then(function (result) {
            if (result.isConfirmed) {
                $.ajax({
                    method: 'POST',
                    url: '/sale/'+sale,
                    data: {
                        '_method': 'DELETE'
                    },
                    dataType: 'JSON'
                }).done(function(response){
                    toastAlert('info', 'Venta eliminada', 'Todo chido, todo fine');
                    dt_basic.ajax.reload();
                })
            }
        });
    }
</script>
<?= $this->endSection() ?>
